var curID=1;
var curItemID;
var favList = {};

favList.isSyncError = false;
favList.isSyncLoading = false;
favList.dialogId = 0;

favList.init = function() {

    // 除文本框外，不允许选择文字
    document.onselectstart = document.ondragstart = function() {
        if (event.target.tagName != 'INPUT') {
            return false;
        }
    };

    /**
     * 按 ESC 键相当于按下“取消”按钮，按回车键相当于按下“确定”按钮
     *
     * 注意：如果是在中文输入法的输入条里面，按字符键之会触发 keyCode=229 的
     * keydown 和 keyup 事件，按功能键会触发 keyCode=229 的 keydown 事件及
     * keyCode 为对应功能键的 keyup 事件，所以为了避免中文输入法状态下的按键
     * 干扰我们的判断，此处应该监听 keydown 而不是 keyup 事件。参见
     * http://blog.darkthread.net/post-2011-04-26-keypress-event-under-ime.aspx
     */
    document.onkeydown = function() {
        if (event.keyCode == 27) {
            document.getElementById("config-cancel").onclick();
        } else if (event.keyCode == 13) {
            document.getElementById("config-confirm").onclick();
        } else {
        }
    };

    // 初始化编辑框
    var param = JSON.parse(localStorage.getItem('dialogParameter'), utils.json_parse_filter);
    // alert('param: ' + JSON.stringify(param));
    if (param && param.action == 'edit') {
        $('#input-title').val(param.title);
        $('#input-url').val(param.url);
    }

    // 设置焦点并全选
    $('#input-url').focus().select();

    // 初始时若 URL 为空，则禁用“确定”按钮
    if ($('#input-url').val() == '') {
        $('#config-confirm').addClass('disabled');
    }

    // 获取整个收藏夹
    try {
        qqbrowser.bookmark.getTree(favList.buildList2);
    } catch (err) {
    }

    // 得到对话框 ID
    try {
        qqbrowser.dialog.id(function(res) {
            var obj = eval("(" + res + ")");
            var dialogId = eval("(" + unescape(obj[0]) + ")");
            favList.dialogId = dialogId;
        });
    } catch (err) {
    }

    /**
     * URL 不能为空，否则禁用“确定”按钮
     */
    document.getElementById("input-url").onkeyup = function() {
        var url = $.trim(this.value);

        if (url == '') {
            document.getElementById("config-confirm").className = 'disabled';
        } else {
            document.getElementById("config-confirm").className = '';
        }
    };

    /**
     * 点击“确定”按钮的事件处理函数
     */
    document.getElementById("config-confirm").onclick = function() {
        if (this.className == 'disabled') {
            return;
        }

        var title = $.trim(document.getElementById("input-title").value);
        var url   = $.trim(document.getElementById("input-url").value);

        /*
         * 判断用户输入的字符串是否是有效的 URL，如果无效，则提示用户重新输入，
         * 如果有效但不带 http[s]:// 前缀，则补全
         */
        if (utils.isValidUrl(url)) {
            if (url.search('^http(s)?://') == -1) {
                url = 'http://' + url;
            }
        } else {
            alert('请输入有效的网址，名称可留空');
            $('#input-url').focus();
            return;
        }

        var obj = {};
        var param = JSON.parse(localStorage.getItem('dialogParameter'));
        obj.action = param.action;
        obj.button = 'OK';
        obj.id     = param.id;
        obj.index  = param.index;
        obj.url    = encodeURI(url);
        obj.title  = title;
        // 设置对话框的返回值
        localStorage.setItem('dialogReturnValue', JSON.stringify(obj));

        // 关闭对话框
        try {
            qqbrowser.dialog.close(0);
        } catch (err) {
            window.close();
        }
    };

    /**
     * 点击“取消”按钮的事件处理函数
     */
    document.getElementById("config-cancel").onclick = function() {
        localStorage.setItem('dialogReturnValue', JSON.stringify({ button: 'Cancel', url: '', title: '' }));
        try {
            qqbrowser.dialog.close(0);
        } catch (err) {
            window.close();
        }
    };

    // 判断是否有异常
    try {
        qqbrowser.bookmark.getSyncState(function(result) {
            var syncStateId = eval('(' + result + ')')[0];
            if(syncStateId == 2) { // 异常时
                favList.isSyncError = true;
                favList.isSyncLoading = false;
            } else if(syncStateId == 1) { // 下载中
                favList.isSyncError = false;
                favList.isSyncLoading = true;
            }
            else {
                favList.isSyncError = false;
                favList.isSyncLoading = false;
            }
        });

        qqbrowser.bookmark.onSyncStateChanged.addListener(function(syncStateId) {
            if(syncStateId == 2) { // 异常时
                favList.isSyncError = true;
                favList.isSyncLoading = false;
            } else if(syncStateId == 1) { // 下载中
                favList.isSyncLoading = true;
                favList.isSyncError = false;
            } else {
                favList.isSyncError = false;
                favList.isSyncLoading = false;
            }
        });
    } catch(e) {}
};


/**
 * createElementWithClassName()
 *
 * 创建具有指定的 class 名称的元素
 */
favList.createElementWithClassName = function(type, className) {
    var element = document.createElement(type);
    element.className = className;
    return element;
};


/**
 * hasChildren()
 */
favList.hasChildren = function(returnData) {
    var returnObject = eval('(' + returnData + ')');
    var unescapedData = unescape(returnObject[0]);
    var favObject = eval('(' + unescapedData + ')');
    // var content = favObject;
    var currentFolderID = returnObject[1];

    // var content=returnData;

    if (favObject.length == 0) {
        var currentFolder = document.getElementById(currentFolderID).childNodes[0];
        currentFolder.className = "blank";
        currentFolder.src = "images/customize_link_dlg/Folder_toplevel_close.png";
    }
    var fchildren = 0;
    for (var i = 0, item; item = favObject[i]; i++) {
        if (item.type == "folder") {
            fchildren++;
        }
    }
    if (fchildren == 0) {
        var currentFolder = document.getElementById(currentFolderID).childNodes[0];
        currentFolder.className = "blank";
        currentFolder.src       = "images/customize_link_dlg/Folder_toplevel_close.png";
    }
};

/**
 * addChild()
 *
 * 向收藏夹树中添加子树
 */
favList.addChild = function(parentNode, content) {
    // alert(JSON.stringify(content));
    for (var i = 0, item; item = content[i]; i++) {
        // 收藏夹项的类型为网页
        if (item.type == "url") {
            // alert('url = ' + item.url);
            var favItemContainer = favList.createElementWithClassName("li", "fav-item");
            favItemContainer.setAttribute('url', item.url);

            // fav icon
            var favIcon = document.createElement("img");
            if (!item.faviconPath) {
                favIcon.src = "images/customize_link_dlg/FavBar_Item.png";
            } else {
                favIcon.src = item.faviconPath;
            }

            favIcon.className = "favicon";
            favIcon.onerror = function() {
                this.src = 'images/customize_link_dlg/FavBar_Item.png';
            };
            favItemContainer.appendChild(favIcon);

            // title
            var favItemTitle = document.createElement('div');
            favItemTitle.className = "title";

            favItemTitle.appendChild(document.createTextNode(item.title));
            favItemContainer.appendChild(favItemTitle);
            favItemContainer.id = item.id;
            favItemContainer.onclick = function() {
                $('.title').removeClass('selected');
                $(event.target).addClass('selected');
                $('#input-title').val($(this, '.title').text());
                $('#input-url').val(this.getAttribute('url'));
                if ($('#input-url').val != '') {
                    $('#config-confirm').removeClass('disabled');
                } else {
                    $('#config-confirm').addClass('disabled');
                }
            };
            favItemContainer.ondblclick = function() {
                $('#config-confirm').click();
            };

            // 把网页项添加到父节点的末尾
            parentNode.appendChild(favItemContainer);

        } else { // 收藏夹项的类型为文件夹
            var favFolder = favList.createElementWithClassName("li", "fav-folder");

            // 创建箭头和文件夹图标
            var img = document.createElement('img');
            img.className = "open";
            img.src = "images/customize_link_dlg/arrow_open.png";
            img.onclick = function() {
                event.cancelBubble = true;
                // alert(event.target.nodeName + '.' + event.target.className);
                if (event.target.className == "closed") {
                    event.target.className = "open";
                    this.src = 'images/customize_link_dlg/arrow_open.png';
                } else if (event.target.className == "open") {
                    event.target.className = "closed";
                    this.src = 'images/customize_link_dlg/arrow_close.png';
                } else {
                }

                var ul = this.nextSibling.nextSibling;
                if (ul.style.display == "none") {
                    ul.style.display = "block";
                } else {
                    ul.style.display = "none";
                }
            };

            // 添加箭头和文件夹图标
            favFolder.appendChild(img);

            // 创建文件夹标题 div
            var title = document.createElement('div');
            title.className = "tilte";
            title.onclick = function() {
                /*
                alert('点击了 title');
                $('div.title-selected').attr('class', 'title');
                event.cancelBubble = true;
                curID = event.srcElement.parentNode.id;
                event.srcElement.className = "title-selected";
                return false;
                */
                /*
                var ul = this.nextSibling;
                if (ul.style.display == "none")
                    ul.style.display = "block";
                else
                    ul.style.display = "none";
                */
            };
            title.appendChild(document.createTextNode(item.title));

            // 添加标题 div
            favFolder.appendChild(title);

            var cchild = document.createElement('ul');
            // cchild.style.display = "block";     // 默认展开文件夹
            favFolder.id = item.id;

            // 添加文件夹内容到父节点
            favList.addChild(cchild, item.children);
            favFolder.appendChild(cchild);

            // 把文件夹添加到父节点的末尾
            parentNode.appendChild(favFolder);
            /*
            try {
                qqbrowser.bookmark.getChildren(parseInt(favFolder.id, 10), 0, favList.hasChildren);
            } catch (e) {
            }
            */
        }
    }
};


/**
 * buildList()
 *
 * 构造收藏夹树
 */
favList.buildList = function(returnData) {
    //alert(returnData);

    var returnObject = eval('(' + returnData + ')');
    document.getElementById("input-title").value = unescape(returnObject[0]);
    document.getElementById("input-url").value = unescape(returnObject[1]);

    var unescapedData = unescape(returnObject[2]);
    //alert(unescapedData);
    var favObject = eval('(' + unescapedData + ')');
    //document.getElementById("input-title").value=returnData[0];
    //document.getElementById("input-url").value=returnData[1];
    curItemID=returnObject[4];

    var content= favObject[0];
    //var content=returnData[2];
    var parentNode=document.getElementById("favFolderList");
    //var item=content[0];
    var item=content;
    /*if(returnData[3]==-1){
        curID=item.id;
    }else{
        curID=returnData[3];
    }*/
    if(returnObject[3]==-1){
        curID=item.children[0].id;
    }else{
        curID=returnObject[3];
    }
    favList.addChild(parentNode,item.children);
    var f=document.getElementById(curID).childNodes;
    if(f!=null){
        f[0].className="open";
        f[0].src="images/customize_link_dlg/arrow_open.png";
        f[1].className="title-selected";
        f[2].style.display="block";
    }

    var nowParent=document.getElementById(curID).parentNode;
    //alert("here");

    if(nowParent!=null){
        //alert(nowParent.id);
        nowParent=nowParent.parentNode;
        //alert(nowParent.id);
        while(nowParent!=null&&nowParent.className!="fav-list"&&nowParent.className!="fav-list-ul"){
            //alert(nowParent.id);
            nowParent.childNodes[0].className="open";
            nowParent.childNodes[0].src="images/customize_link_dlg/arrow_open.png";
            nowParent.childNodes[2].style.display="block";
            nowParent=nowParent.parentNode;
            if(nowParent!=null&&nowParent.className!="fav-list"&&nowParent.className!="fav-list-ul"){
                //alert(nowParent.id);
                nowParent=nowParent.parentNode;

            }
        }
    }

    var temp = document.getElementById('config-confirm');
    if (temp != null) {
        temp.focus();
        // temp.setSelectionRange(0, temp.value.length);
    } else {
        // alert("null");
    }
};

$(function() {
    favList.init();
});

////////////////////////////////////////////////////////////////////////////////

favList.buildList2 = function(returnData) {
    var returnObject = eval('(' + returnData + ')');
    var unescapedData = unescape(returnObject[0]);
    var favObject = eval('(' + unescapedData + ')');
    var content = favObject[0].children;

    var parent = document.getElementById("favList");
    parent.innerHTML = "";
    favList.addChild(parent, content);

    favList.openRoot();
    document.onselectstart = function() {
        return false;
    };

    // alert(parent.innerHTML);
    localStorage.setItem('favTree', parent.innerHTML);
};


/**
 * openRoot()
 *
 * 打开根目录
 */
favList.openRoot = function() {
    var div = $('#favList > li:first-child + li > div');
    div.addClass('open');
    div.next().toggle(); // show tree
}


/**
 * openFolder()
 *
 * 打开相应文件夹
 */
favList.openFolder = function(id) {
    var div = $('#' + id + ' > div');
    div.addClass('open');
    div.next().show(); // show tree

    $('#' + id).next().removeClass('enabled');
}
